import asyncio
from typing import Union, Optional
from pathlib import Path
import rubpy


class SendMusic:
    async def send_music(
        self: "rubpy.Client",
        object_guid: str,
        music: Union[Path, bytes],
        caption: Optional[str] = None,
        reply_to_message_id: Optional[str] = None,
        auto_delete: Optional[int] = None,
        *args, **kwargs,
    ) -> rubpy.types.Update:
        """
        Send a music with a professional sending animation + progress bar.
        """
        # مرحله ۱: ارسال پیام موقت
        anim_msg = await self.send_message(
            object_guid=object_guid,
            text="🎵 آماده‌سازی آهنگ ...",
            reply_to_message_id=reply_to_message_id,
        )

        # مرحله ۲: انیمیشن با progress bar
        async def animate_message():
            progress = 0
            bar_length = 10  # طول نوار پیشرفت
            while True:
                try:
                    # محاسبه درصد و نوار
                    filled = int(progress / (100 / bar_length))
                    bar = "▓" * filled + "░" * (bar_length - filled)
                    text = f"📀 در حال ارسال آهنگ...\n[{bar}] {progress}%"

                    await self.edit_message(
                        object_guid=object_guid,
                        message_id=anim_msg["message_update"]["message_id"],
                        text=text
                    )

                    await asyncio.sleep(0.6)
                    progress += 5
                    if progress > 100:
                        progress = 0  # لوپ بشه تا وقتی آهنگ ارسال نشده
                except Exception:
                    break

        animation_task = asyncio.create_task(animate_message())

        # مرحله ۳: ارسال آهنگ
        try:
            result = await self.send_message(
                object_guid=object_guid,
                text=caption,
                reply_to_message_id=reply_to_message_id,
                file_inline=music,
                type='Music',
                auto_delete=auto_delete,
                *args, **kwargs
            )
        finally:
            # مرحله ۴: توقف انیمیشن
            animation_task.cancel()
            try:
                # پیام نهایی + progress کامل
                await self.edit_message(
                    object_guid=object_guid,
                    message_id=anim_msg["message_update"]["message_id"],
                    text="✅ آهنگ با موفقیت ارسال شد!\n[▓▓▓▓▓▓▓▓▓▓] 100%"
                )
                await asyncio.sleep(1.2)
                await self.delete_messages(object_guid, [anim_msg["message_update"]["message_id"]])
            except Exception:
                pass

        return result
