import packages_local.rubpy


class UploadFile:
    """
    Provides a method to upload a file.

    Methods:
    - upload: Upload a file.

    Attributes:
    - self (packages_local.rubpy.Client): The packages_local.rubpy client instance.
    """

    async def upload(self: "packages_local.rubpy.Client", file, *args, **kwargs) -> "packages_local.rubpy.types.Update":
        """
        Upload a file.

        Args:
        - file: The file to be uploaded.
        - *args: Additional positional arguments.
        - **kwargs: Additional keyword arguments.

        Returns:
        - The result of the file upload operation.
        """
        return await self.connection.upload_file(file=file, *args, **kwargs)
