<?php
header("Content-Type: application/json; charset=utf-8");

// خواندن فایل JSON
$filename = "doas_200.json";
if (!file_exists($filename)) {
    echo json_encode(["error" => "فایل دعا پیدا نشد."]);
    exit;
}

$data = json_decode(file_get_contents($filename), true);

// بررسی صحت
if (!is_array($data) || count($data) === 0) {
    echo json_encode(["error" => "لیست دعاها نامعتبر است."]);
    exit;
}

// انتخاب تصادفی
$random_doa = $data[array_rand($data)];

// نمایش خروجی
echo json_encode($random_doa, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
