<?php
header('Content-Type: application/json; charset=utf-8');

function getRemoteHTML($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'Mozilla/5.0',
    ]);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}

// محتوای HTML از سایت می‌گیریم
$html = getRemoteHTML("https://taw-bio.ir/blog/Horn+text");

// اگه خطا داشتیم، خروجی خطا بدیم
if (!$html) {
    echo json_encode(['error' => 'خطا در دریافت محتوا']);
    exit;
}

// شروع پردازش HTML با DOM
libxml_use_internal_errors(true);
$doc = new DOMDocument();
$doc->loadHTML('<?xml encoding="utf-8" ?>' . $html);
libxml_clear_errors();

$xpath = new DOMXPath($doc);

// همه‌ی مقادیر داخل تگ‌های <article class="iTxt"> رو بگیر
$nodes = $xpath->query('//article[@class="iTxt"]/div[@class="t fa"]/p');

$texts = [];

foreach ($nodes as $node) {
    $text = trim($node->nodeValue);
    if (!empty($text)) {
        $texts[] = $text;
    }
}

// اگه متنی پیدا نشد، پیام خطا بده
if (empty($texts)) {
    echo json_encode(['error' => 'متنی پیدا نشد']);
    exit;
}

// متن تصادفی
$randomText = $texts[array_rand($texts)];

echo json_encode(['text' => $randomText], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
