<?php
date_default_timezone_set("Asia/Tehran");

function faToEn($string) {
    $fa = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $en = ['0','1','2','3','4','5','6','7','8','9'];
    return str_replace($fa, $en, $string);
}

// زمان و تاریخ میلادی
$gregorian = date("Y/m/d");
$time = date("H:i:s");
$hour = (int)date("H");

if ($hour < 4) $moment = "نیمه‌شب";
elseif ($hour < 12) $moment = "صبح";
elseif ($hour < 16) $moment = "ظهر";
elseif ($hour < 20) $moment = "عصر";
else $moment = "شب";

// قالب‌دهنده
$formatter = fn($pattern) => new IntlDateFormatter(
    "fa_IR@calendar=persian", IntlDateFormatter::FULL, IntlDateFormatter::NONE,
    "Asia/Tehran", IntlDateFormatter::TRADITIONAL, $pattern
);

// تاریخ شمسی با اعداد انگلیسی
$jalali = faToEn($formatter("yyyy/MM/dd")->format(time()));
$weekday = $formatter("EEEE")->format(time());
$weekday_num = (int)date("N");

$year = (int)faToEn($formatter("yyyy")->format(time()));
$month_num = (int)faToEn($formatter("MM")->format(time()));
$day = (int)faToEn($formatter("dd")->format(time()));

// نام ماه شمسی
$jalali_months = [
    1 => "فروردین", 2 => "اردیبهشت", 3 => "خرداد", 4 => "تیر",
    5 => "مرداد", 6 => "شهریور", 7 => "مهر", 8 => "آبان",
    9 => "آذر", 10 => "دی", 11 => "بهمن", 12 => "اسفند"
];
$month_name = $jalali_months[$month_num] ?? null;

// فصل
$season = match(true) {
    $month_num <= 3 => "بهار",
    $month_num <= 6 => "تابستان",
    $month_num <= 9 => "پاییز",
    default => "زمستان",
};

// حیوان سال
$animals = ["موش", "گاو", "ببر", "گربه", "اژدها", "مار", "اسب", "بز", "میمون", "خروس", "سگ", "خوک"];
$animal = $animals[($year - 1399) % 12];

// کبیسه و روز سال
$is_kabise = (($year + 38) * 682 % 2816) < 682;
$days_in_month = [0, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, $is_kabise ? 30 : 29];
$day_of_year = array_sum(array_slice($days_in_month, 1, $month_num - 1)) + $day;
$progress_percent = round(($day_of_year / array_sum($days_in_month)) * 100, 2);

// انگلیسی‌سازی روز و ماه میلادی
$month_en = date("F");
$weekday_en = date("l");

// اختلاف زمانی با UTC
$timezone_offset = date("P");

$response = [
    "time" => $time,
    "year_jalali" => $jalali,
    "year_miladi" => $gregorian,
    "day" => $weekday,
    "day_en" => $weekday_en,
    "day_number" => $weekday_num,
    "animal" => $animal,
    "month" => $month_name,
    "month_en" => $month_en,
    "season" => $season,
    "day_of_year" => $day_of_year,
    "progress_of_year" => "$progress_percent%",
    "is_kabise" => $is_kabise,
    "timezone" => "Asia/Tehran",
    "timezone_offset" => $timezone_offset,
    "moment" => $moment
];

header('Content-Type: application/json; charset=utf-8');
echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
