<?php
// تنظیم هدر برای JSON
header('Content-Type: application/json');

// دریافت پارامتر action از GET یا POST
$action = $_GET['action'] ?? 'randomText';

if ($action === 'randomText') {
    // URL سایت مورد نظر
    $url = 'https://taw-bio.ir/f/src/text/%D8%AD%D9%82~1~all~bst';

    // دریافت محتوای سایت
    $html = file_get_contents($url);
    
    if ($html === FALSE) {
        echo json_encode(['error' => 'Unable to retrieve data from the website']);
        exit;
    }
    
    // لود کردن HTML با استفاده از DOMDocument
    $dom = new DOMDocument();
    libxml_use_internal_errors(true); // برای جلوگیری از اخطارهای غیر معتبر HTML
    $dom->loadHTML($html);
    libxml_clear_errors();

    // استفاده از DOMXPath برای جستجوی عناصر
    $xpath = new DOMXPath($dom);

    // پیدا کردن همه divهایی که کلاس 't fa' دارند (که متن داخلشون هست)
    $texts = $xpath->query("//div[@class='t fa']");

    if ($texts->length > 0) {
        // انتخاب یک متن تصادفی
        $randomIndex = rand(0, $texts->length - 1);
        $randomText = $texts->item($randomIndex)->nodeValue;

        // ارسال متن استخراج‌شده در قالب JSON
        echo json_encode(['text' => $randomText]);
    } else {
        echo json_encode(['error' => 'No texts found on the page']);
    }
} else {
    // در صورتی که درخواست action معتبر نباشه
    echo json_encode(['error' => 'Invalid action']);
}
?>
